---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：9-next typegen

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **route-types-utils.tsの内部処理**: createRouteTypesManifestの詳細な生成ロジックは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/cli/next-typegen.ts` - next typegenコマンドの実装（205行）
- E-02: `packages/next/src/bin/next.ts` - CLIエントリーポイント（445-463行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NextTypegenOptionsはdirプロパティのみ | E-01 (38-40行目) | ○ |
| C-02 | プロジェクトディレクトリの存在確認 | E-01 (49-51行目) | ○ |
| C-03 | PHASE_PRODUCTION_BUILDで設定読み込み | E-01 (53行目) | ○ |
| C-04 | SWCバインディングインストール | E-01 (54行目) | ○ |
| C-05 | findPagesDirでpagesDir/appDir取得 | E-01 (56行目) | ○ |
| C-06 | verifyTypeScriptSetup実行 | E-01 (60-72行目) | ○ |
| C-07 | route-types.d.tsとroutes.d.tsは別ファイル | E-01 (78-79行目, 190-191行目) | ○ |
| C-08 | typesディレクトリをrecursiveで作成 | E-01 (80行目) | ○ |
| C-09 | collectPagesFilesでページファイル収集 | E-01 (117行目) | ○ |
| C-10 | collectAppFilesでページ・レイアウト・デフォルトファイル収集 | E-01 (130-133行目) | ○ |
| C-11 | extractSlots + combineSlots | E-01 (140-144行目) | ○ |
| C-12 | processAppRoutes/processLayoutRoutes | E-01 (146-156行目) | ○ |
| C-13 | createRouteTypesManifest呼び出し | E-01 (159-170行目) | ○ |
| C-14 | 4つのファイル書き込み | E-01 (172-200行目) | ○ |
| C-15 | process.exit(0)で強制終了 | E-02 (460行目) | ○ |
| C-16 | isSrcDirの判定ロジック | E-01 (111-113行目) | ○ |
| C-17 | cacheLife型定義の生成 | E-01 (185-186行目) | ○ |
| C-18 | createRouteTypesManifestの内部処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- createRouteTypesManifestの内部処理（型定義の具体的な生成ロジック）はroute-types-utils.tsに実装されているが詳細を未確認
  - 候補：route-types-utils.tsの実装確認

## 5) リスクフラグ（レビュー観点）
- 0: 型定義の生成ロジックの詳細はroute-types-utils.tsに委譲されている
- 0: redirects/rewritesがマニフェストに含まれる旨の詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] 出力される4つのファイルの役割と出力先が正確か
- [ ] Pages Router / App Routerの両方のルート処理が記載されているか
- [ ] strictRouteTypes / typedRoutesの設定反映が正しく記載されているか
- [ ] collectAppFilesの収集対象（ページ、レイアウト、デフォルト）が正しいか
